using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Intemi.InTrees
{
    public partial class NodeDataForm : Form
    {
        public NodeDataForm()
        {
            InitializeComponent();
        }

        public void Init(DTNode dtNode)
        {
            IDataTable dataTable = dtNode.DataTable;
            IOneFeatureData tt = (dataTable as ITargets).Targets;
            IVectorEnumerator ve = (IVectorEnumerator)dataTable.InstanceEnumerator();

            this.txtAcc.Text= dtNode.Accuracy.ToString();
            this.txtPos.Text = dtNode.Positive.ToString();
            this.txtVectorCount.Text = dtNode.InstanceCount.ToString();
            if (!dtNode.IsLeaf)
            {
                this.txtTestRank.Text = dtNode.NodeTest.TestRate.ToString();
            }
            this.txtLabel.Text = dtNode.Target.ToString();

            dataGridView1.Columns.Add("lp", "lp");
            dataGridView1.Columns.Add("klasa", "klasa");
            for (int i = 0; i < dataTable.FeaturesInfo.Count; i++) 
            {
                dataGridView1.Columns.Add(dataTable.FeaturesInfo[i].Name, dataTable.FeaturesInfo[i].Name);
            }

            for (int i = 0; i < dataTable.InstanceCount; i++)
            {
                dataGridView1.Rows.Add();
                dataGridView1.Rows[i].Cells[0].Value = i+1;
                //dataGridView1.Rows[i].Cells[1].Value = tt.ValueAsString(i, 0);
                dataGridView1.Rows[i].Cells[1].Value = tt[i];
                ve.GoToInstance(i);
                for (int j = 2; j < dataGridView1.Columns.Count; j++)
                {
                    dataGridView1.Rows[i].Cells[j].Value = ve.Vector[j - 2];
                }
            }
        }
    }
}